﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
''' <summary>
'''customer 类表示客户名称和 ID 编号。通过实现
'''  IComparable 接口，我们能够支持对此类的数组和集合进行排序。 
''' </summary>
Public Class Customer
    Implements IComparable

    Private mName As String
    Private mId As Integer

    Public Sub New(ByVal new_name As String, ByVal new_id As Integer)
        mName = new_name
        mId = new_id
    End Sub


    Public Overrides Function ToString() As String
        Return mId.ToString() + ": " + mName
    End Function


    ''' <summary>
    '''CompareTo 函数是 IComarable 接口的实现。对于 customer 类，
    ''' 我们仅实现 ID 字段的比较。这意味着对这些对象 
    ''' 的数组或集合执行的任何排序都将依据客户 ID 进行。
    ''' </summary>
    Public Function CompareTo(ByVal obj As Object) As Integer Implements IComparable.CompareTo


        ' 首先检查以确保正在将此实例与另一个客户进行比较。
        If TypeOf obj Is Customer Then
            ' 创建强类型的 obj 实例。
            Dim c As Customer
            c = CType(obj, Customer)

            If c.ID = Me.ID Then
                Return 0
            ElseIf c.ID < Me.ID Then
                Return 1
            Else
                Return -1
            End If
        Else
            Throw New ArgumentException("Customers can only be compared to other customers.")
        End If
    End Function

    ''' <summary>
    ''' 客户的名称
    ''' </summary>
    Public Property Name() As String
        Get
            Return mName
        End Get
        Set(ByVal Value As String)
            mName = Value
        End Set
    End Property

    ''' <summary>
    ''' 客户的 ID
    ''' </summary>
    Public Property ID() As Integer
        Get
            Return mId
        End Get
        Set(ByVal Value As Integer)
            mId = Value
        End Set
    End Property

End Class
